

###################################################################################################################
####################### READ AND PREPARE VARS #############################################################
###################################################################################################################
# 
# dat_aug = read.dta13("C:/Dropbox/Dataset/Indikator Politik Indonesia/Survei_Telepon_Diego_Agustus 2020.dta",
#                convert.factors = FALSE)
# 
# cols_tokeep = c("Age", "gender", "V_38", "V_40", "PROVINSI", "V_49",
#                 "EXP", "V_35_A", "V_35_B", "bobot", "Agama", "desakota")
# 
# dat_aug = dat_aug[, cols_tokeep]
# 
# save(dat_aug, file="August 2020.dat")


load("August 2020.dat")

## Demographic variables
dat_aug$age = dat_aug$Age
dat_aug$female = car::recode(dat_aug$gender, "1=0; 2=1")
dat_aug$edu = car::recode(dat_aug$V_38, "88=NA")
dat_aug$income = car::recode(dat_aug$V_40, "88=NA")

dat_aug$javaisland = car::recode(dat_aug$PROVINSI, "11=1; 12=1; 13=1; 14=1; 15=1; 16=1; else=0")


## Religiosity
dat_aug$considerrel = car::recode(dat_aug$V_49, "1=4; 2=3; 3=2; 4=1; 8=NA")

## Treatment Assigment
dat_aug$sharia = 0
dat_aug$sharia[which(dat_aug$EXP == "V_35_B")] = 1

## Dependent Variable
dat_aug$dvvote = NA
dat_aug$dvvote[which(dat_aug$sharia==0)] = dat_aug$V_35_A[which(dat_aug$sharia==0)]
dat_aug$dvvote[which(dat_aug$sharia==1)] = dat_aug$V_35_B[which(dat_aug$sharia==1)]
dat_aug$dvvote = car::recode(dat_aug$dvvote, "1=0; 2=1; 8=NA")


## Survey Design
svydat_aug = svydesign(id=~1, data=dat_aug, weights = dat_aug$bobot)
svydat_aug.muslim = subset(svydat_aug, subset=(Agama==1))


###################################################################################################################
## Balance Check
###################################################################################################################

sink("Balance Check August 2020.txt")
# female
print("Female ==========")
print(summary(aov(female ~ sharia, subset(dat_aug, Agama==1))))

# age
print("Age ==========")
print(summary(aov(age ~ sharia, subset(dat_aug, Agama==1))))

# edu
print("Education ==========")
print(summary(aov(edu ~ sharia, subset(dat_aug, Agama==1))))

# income
print("Income ==========")
print(summary(aov(income ~ sharia, subset(dat_aug, Agama==1))))

# considerrel
print("Consider Religion ==========")
print(summary(aov(considerrel ~ sharia, subset(dat_aug, Agama==1))))

sink(NULL)
